/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.UUID;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.INameSetter;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.KeypadFurnaceBlock;
import net.geforcemods.securitycraft.inventory.InsertOnlySidedInvWrapper;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PasscodeUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.SlotFurnaceFuel;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class KeypadFurnaceBlockEntity
extends DisguisableBlockEntity
implements ISidedInventory,
IPasscodeProtected,
ITickable,
INameSetter,
ILockable {
    private IItemHandler insertOnlyHandlerTop;
    private IItemHandler insertOnlyHandlerBottom;
    private IItemHandler insertOnlyHandlerSide;
    private static final int[] slotsTop = new int[]{0};
    private static final int[] slotsBottom = new int[]{2, 1};
    private static final int[] slotsSides = new int[]{1};
    private NonNullList<ItemStack> furnaceItemStacks = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    private int furnaceBurnTime;
    private int currentItemBurnTime;
    private int cookTime;
    private int totalCookTime;
    private String furnaceCustomName;
    private byte[] passcode;
    private UUID saltKey;
    private boolean saveSalt = false;
    private NonNullList<ItemStack> modules = NonNullList.func_191197_a((int)this.getMaxNumberOfModules(), (Object)ItemStack.field_190927_a);
    private Option.BooleanOption sendAllowlistMessage = new Option.SendAllowlistMessageOption(false);
    private Option.BooleanOption sendDenylistMessage = new Option.SendDenylistMessageOption(true);
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.SmartModuleCooldownOption smartModuleCooldown = new Option.SmartModuleCooldownOption(() -> ((KeypadFurnaceBlockEntity)this).func_174877_v());
    private long cooldownEnd = 0L;

    public int func_70302_i_() {
        return this.furnaceItemStacks.size();
    }

    public ItemStack func_70301_a(int index) {
        return index >= 100 ? this.getModuleInSlot(index) : (ItemStack)this.furnaceItemStacks.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        if (!((ItemStack)this.furnaceItemStacks.get(index)).func_190926_b()) {
            if (((ItemStack)this.furnaceItemStacks.get(index)).func_190916_E() <= count) {
                ItemStack stack = (ItemStack)this.furnaceItemStacks.get(index);
                this.furnaceItemStacks.set(index, (Object)ItemStack.field_190927_a);
                return stack;
            }
            ItemStack stack = ((ItemStack)this.furnaceItemStacks.get(index)).func_77979_a(count);
            if (((ItemStack)this.furnaceItemStacks.get(index)).func_190916_E() == 0) {
                this.furnaceItemStacks.set(index, (Object)ItemStack.field_190927_a);
            }
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int index) {
        if (!((ItemStack)this.furnaceItemStacks.get(index)).func_190926_b()) {
            ItemStack stack = (ItemStack)this.furnaceItemStacks.get(index);
            this.furnaceItemStacks.set(index, (Object)ItemStack.field_190927_a);
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack furnaceStack = (ItemStack)this.furnaceItemStacks.get(index);
        boolean areStacksEqual = !stack.func_190926_b() && stack.func_77969_a(furnaceStack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)furnaceStack);
        this.furnaceItemStacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !areStacksEqual) {
            this.totalCookTime = this.getTotalCookTime();
            this.cookTime = 0;
            this.func_70296_d();
        }
    }

    @Override
    public String func_70005_c_() {
        return this.furnaceCustomName;
    }

    @Override
    public boolean func_145818_k_() {
        return this.furnaceCustomName != null && !this.furnaceCustomName.isEmpty() && !this.furnaceCustomName.equals(this.getDefaultName().func_150254_d());
    }

    @Override
    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : this.getDefaultName();
    }

    @Override
    public ITextComponent getDefaultName() {
        return Utils.localize(SCContent.keypadFurnace, new Object[0]);
    }

    @Override
    public void setCustomName(String customName) {
        this.furnaceCustomName = customName;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagList list = tag.func_150295_c("Items", 10);
        this.furnaceItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound stackTag = list.func_150305_b(i);
            byte slot = stackTag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.furnaceItemStacks.size()) continue;
            this.furnaceItemStacks.set((int)slot, (Object)new ItemStack(stackTag));
        }
        this.furnaceBurnTime = tag.func_74765_d("BurnTime");
        this.cookTime = tag.func_74765_d("CookTime");
        this.totalCookTime = tag.func_74765_d("CookTimeTotal");
        this.currentItemBurnTime = TileEntityFurnace.func_145952_a((ItemStack)((ItemStack)this.furnaceItemStacks.get(1)));
        this.loadSaltKey(tag);
        this.loadPasscode(tag);
        long cooldownLeft = this.getCooldownEnd() - System.currentTimeMillis();
        tag.func_74772_a("cooldownLeft", cooldownLeft <= 0L ? -1L : cooldownLeft);
        this.furnaceCustomName = tag.func_74779_i("CustomName");
        if (tag.func_74764_b("sendMessage") && !tag.func_74767_n("sendMessage")) {
            this.sendAllowlistMessage.setValue(false);
            this.sendDenylistMessage.setValue(false);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74777_a("BurnTime", (short)this.furnaceBurnTime);
        tag.func_74777_a("CookTime", (short)this.cookTime);
        tag.func_74777_a("CookTimeTotal", (short)this.totalCookTime);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.furnaceItemStacks.size(); ++i) {
            if (((ItemStack)this.furnaceItemStacks.get(i)).func_190926_b()) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.func_74774_a("Slot", (byte)i);
            ((ItemStack)this.furnaceItemStacks.get(i)).func_77955_b(stackTag);
            list.func_74742_a((NBTBase)stackTag);
        }
        tag.func_74782_a("Items", (NBTBase)list);
        this.savePasscodeAndSalt(tag);
        tag.func_74772_a("cooldownLeft", this.getCooldownEnd() - System.currentTimeMillis());
        if (this.func_145818_k_()) {
            tag.func_74778_a("CustomName", this.furnaceCustomName);
        }
        return tag;
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        return PasscodeUtils.filterPasscodeAndSaltFromTag(this.func_189515_b(new NBTTagCompound()));
    }

    public int func_70297_j_() {
        return 64;
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int scaleFactor) {
        return this.cookTime * scaleFactor / 200;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int scaleFactor) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return this.furnaceBurnTime * scaleFactor / this.currentItemBurnTime;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    public void func_73660_a() {
        if (this.isDisabled()) {
            return;
        }
        boolean wasBurning = this.isBurning();
        boolean shouldMarkDirty = false;
        if (this.isBurning()) {
            --this.furnaceBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack fuelStack = (ItemStack)this.furnaceItemStacks.get(1);
            if (!this.isBurning() && (fuelStack.func_190926_b() || ((ItemStack)this.furnaceItemStacks.get(0)).func_190926_b())) {
                if (!this.isBurning() && this.cookTime > 0) {
                    this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.totalCookTime);
                }
            } else {
                if (!this.isBurning() && this.canSmelt()) {
                    this.currentItemBurnTime = this.furnaceBurnTime = TileEntityFurnace.func_145952_a((ItemStack)fuelStack);
                    if (this.isBurning()) {
                        shouldMarkDirty = true;
                        if (!fuelStack.func_190926_b()) {
                            fuelStack.func_190918_g(1);
                            if (fuelStack.func_190916_E() == 0) {
                                this.furnaceItemStacks.set(1, (Object)fuelStack.func_77973_b().getContainerItem(fuelStack));
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt()) {
                    ++this.cookTime;
                    if (this.cookTime == this.totalCookTime) {
                        this.cookTime = 0;
                        this.totalCookTime = this.getTotalCookTime();
                        this.smeltItem();
                        shouldMarkDirty = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            }
            if (wasBurning != this.isBurning()) {
                shouldMarkDirty = true;
                this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)KeypadFurnaceBlock.LIT, (Comparable)Boolean.valueOf(this.isBurning())));
            }
        }
        if (shouldMarkDirty) {
            this.func_70296_d();
        }
    }

    public int getTotalCookTime() {
        return 200;
    }

    private boolean canSmelt() {
        if (((ItemStack)this.furnaceItemStacks.get(0)).func_190926_b()) {
            return false;
        }
        ItemStack smeltResult = FurnaceRecipes.func_77602_a().func_151395_a((ItemStack)this.furnaceItemStacks.get(0));
        if (smeltResult.func_190926_b()) {
            return false;
        }
        ItemStack outputStack = (ItemStack)this.furnaceItemStacks.get(2);
        if (outputStack.func_190926_b()) {
            return true;
        }
        if (!outputStack.func_77969_a(smeltResult)) {
            return false;
        }
        int resultAmount = outputStack.func_190916_E() + smeltResult.func_190916_E();
        return resultAmount <= this.func_70297_j_() && resultAmount <= outputStack.func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack fuelStack = (ItemStack)this.furnaceItemStacks.get(0);
            ItemStack inputStack = (ItemStack)this.furnaceItemStacks.get(1);
            ItemStack smeltResult = FurnaceRecipes.func_77602_a().func_151395_a(fuelStack);
            ItemStack outputStack = (ItemStack)this.furnaceItemStacks.get(2);
            if (outputStack.func_190926_b()) {
                this.furnaceItemStacks.set(2, (Object)smeltResult.func_77946_l());
            } else if (outputStack.func_77973_b() == smeltResult.func_77973_b()) {
                outputStack.func_190917_f(smeltResult.func_190916_E());
            }
            if (fuelStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150360_v) && fuelStack.func_77960_j() == 1 && !inputStack.func_190926_b() && inputStack.func_77973_b() == Items.field_151133_ar) {
                this.furnaceItemStacks.set(1, (Object)new ItemStack(Items.field_151131_as));
            }
            fuelStack.func_190918_g(1);
            if (fuelStack.func_190916_E() <= 0) {
                this.furnaceItemStacks.set(0, (Object)ItemStack.field_190927_a);
            }
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.furnaceItemStacks) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index != 2 && (index != 1 || TileEntityFurnace.func_145954_b((ItemStack)stack) || SlotFurnaceFuel.func_178173_c_((ItemStack)stack) && ((ItemStack)this.furnaceItemStacks.get(1)).func_77973_b() != Items.field_151133_ar);
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? slotsBottom : (side == EnumFacing.UP ? slotsTop : slotsSides);
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
        return this.func_94041_b(index, stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        Item item;
        return direction != EnumFacing.DOWN || index != 1 || (item = stack.func_77973_b()) == Items.field_151131_as || item == Items.field_151133_ar;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.furnaceBurnTime;
            }
            case 1: {
                return this.currentItemBurnTime;
            }
            case 2: {
                return this.cookTime;
            }
            case 3: {
                return this.totalCookTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.furnaceBurnTime = value;
                break;
            }
            case 1: {
                this.currentItemBurnTime = value;
                break;
            }
            case 2: {
                this.cookTime = value;
                break;
            }
            case 3: {
                this.totalCookTime = value;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown field id passed to KeypadFurnaceBlock#setField %s", id));
            }
        }
    }

    public int func_174890_g() {
        return 4;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.furnaceItemStacks.size(); ++i) {
            this.furnaceItemStacks.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public boolean enableHack() {
        return true;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)(BlockUtils.isAllowedToExtractFromProtectedObject(facing, this) ? super.getCapability(capability, facing) : this.getInsertOnlyHandler(facing));
        }
        return (T)super.getCapability(capability, facing);
    }

    private IItemHandler getInsertOnlyHandler(EnumFacing facing) {
        if (facing == EnumFacing.DOWN) {
            if (this.insertOnlyHandlerBottom == null) {
                this.insertOnlyHandlerBottom = new InsertOnlySidedInvWrapper(this, EnumFacing.DOWN);
            }
            return this.insertOnlyHandlerBottom;
        }
        if (facing == EnumFacing.UP) {
            if (this.insertOnlyHandlerTop == null) {
                this.insertOnlyHandlerTop = new InsertOnlySidedInvWrapper(this, EnumFacing.UP);
            }
            return this.insertOnlyHandlerTop;
        }
        if (this.insertOnlyHandlerSide == null) {
            this.insertOnlyHandlerSide = new InsertOnlySidedInvWrapper(this, EnumFacing.WEST);
        }
        return this.insertOnlyHandlerSide;
    }

    @Override
    public void activate(EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K) {
            ((KeypadFurnaceBlock)this.func_145838_q()).activate(this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b, this.field_174879_c, player);
        }
    }

    @Override
    public byte[] getPasscode() {
        return this.passcode == null || this.passcode.length == 0 ? null : this.passcode;
    }

    @Override
    public void setPasscode(byte[] passcode) {
        this.passcode = passcode;
    }

    @Override
    public UUID getSaltKey() {
        return this.saltKey;
    }

    @Override
    public void setSaltKey(UUID saltKey) {
        this.saltKey = saltKey;
    }

    @Override
    public void setSaveSalt(boolean saveSalt) {
        this.saveSalt = saveSalt;
    }

    @Override
    public boolean shouldSaveSalt() {
        return this.saveSalt;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.modules;
    }

    @Override
    public void startCooldown() {
        if (!this.isOnCooldown()) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.cooldownEnd = System.currentTimeMillis() + (long)((Integer)this.smartModuleCooldown.get() * 50);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            this.func_70296_d();
        }
    }

    @Override
    public long getCooldownEnd() {
        return this.cooldownEnd;
    }

    @Override
    public boolean isOnCooldown() {
        return System.currentTimeMillis() < this.getCooldownEnd();
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DENYLIST, ModuleType.DISGUISE, ModuleType.SMART, ModuleType.HARMING};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendAllowlistMessage, this.sendDenylistMessage, this.disabled, this.smartModuleCooldown};
    }

    public boolean sendsAllowlistMessage() {
        return (Boolean)this.sendAllowlistMessage.get();
    }

    public boolean sendsDenylistMessage() {
        return (Boolean)this.sendDenylistMessage.get();
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }
}

